package testsUnitaires;

import static org.junit.jupiter.api.Assertions.*;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import m.Dessert;

class DessertTest {
	
    private Dessert dessert;

//S'exécutera avant chaque test
    @BeforeEach
    void instanceDessert() {
    	//Instanciation d'un dessert quelconque
    	dessert = new Dessert("Profiterole", 5.8);
    }
    

//Vérifie si les getters et setters fonctionnent correctement
    @Test
    void testGetNomDessert() {
    	//Compare si le nom du dessert est bien un profiterole
        assertEquals("Profiterole", dessert.getNomDessert());
    }

    @Test
    void testSetNomDessert() {
    	dessert.setNomDessert("Glace");
      //Compare si le nom du dessert a bien été modifié en glace
        assertEquals("Glace", dessert.getNomDessert());
    }

    @Test
    void testGetPrixDessert() {
        assertEquals(5.8, dessert.getPrixDessert());
    }

    @Test
    void testSetPrixDessert() {
    	dessert.setPrixDessert(3.0);
        assertEquals(4.0, dessert.getPrixDessert());
    }
}
